#**************************************************************************
# PROJECT: Interrupts in Decoupled Parallel Mode for MPC5675K	           #
# FILE NAME: ctr0_VLE_Flash.s           COPYRIGHT (c) Freescale 2008  	   #
# Description: This file set up the MMU table, initializing RAM and global #
#		variables for both cores.				   #
#==========================================================================#
# REV     AUTHOR         DATE        DESCRIPTION OF CHANGE            	   #
# ---   -----------   -----------    ---------------------            	   #
# 0.5   T.Kulig	      16 Feb 2012    Copy global variable to RAM      	   #	
# 0.4   M. Ruthenbeck 7 June 2010    Move sram1 init to core 1 section	   #
# 0.3   Shanaka Yapa  17 May 2010    Add the SRAM0/1 Initialization   	   #
# 0.2   M Ruthenbeck  14 May 2010    Updated to work with MMU issue   	   #
# 0.1   M Ruthenbeck  13 Apr 2010    Updated for MPC5647K             	   #
# 0.0   Sim, Mong     Feb 11,2010    Demostrates one project, one          #
#                                    entry point, re-entrant function      #
#                                    dual core application            	   #
#                                                                          #
#***************************************************************************
#  LICENSE: 
#  Copyright (c) 2012 Freescale Semiconductor
#  
#  Permission is hereby granted, free of charge, to any person 
#  obtaining a copy of this software and associated documentation 
#  files (the "Software"), to deal in the Software without 
#  restriction, including without limitation the rights to use, 
#  copy, modify, merge, publish, distribute, sublicense, and/or 
#  sell copies of the Software, and to permit persons to whom the 
#  Software is furnished to do so, subject to the following 
#  conditions:
#  
#  The above copyright notice and this permission notice 
#  shall be included in all copies or substantial portions 
#  of the Software.
#  
#  THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
#  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
#  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
#  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
#  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
#  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
#  DEALINGS IN THE SOFTWARE.
#***************************************************************************/

        ##------- Reset Configuration Half Word -------------------------------- 
        .section .rcw
    
        .LONG 0x015A015A        # VLE ON, Valid Bood Identifier 0x5A        
        .LONG _start            # Code starts at _start      

        ##----------------------------------------------------------------------     
        # Watchdogs disable in shadow FLASH.

        .section    ".vletext", "vax"
        .vle
        .globl      _start
        .align 2
    
_start:
        # Set up MMU
        # Flash area - setup direct, No translation
        # MAS0 : ESEL=0 
        # MAS1 : TSIZ=4Mbytes  Cover Flash, Data Flash and EBI
        # MAS2 : EPN=0x000000000, VLE=1, W=0, I=0, M=0, G=0, E=big 
        # MAS3 : RPN=0x000000000, PERMIS=all 

        e_lis   r3, 0x1000               
        mtMAS0  r3

        e_lis   r4, 0xC000               
        e_or2i  r4, 0x0600               
        mtMAS1  r4

        e_lis   r5, 0x0000               
        e_or2i  r5, 0x0020               
        mtMAS2  r5

        e_lis   r6, 0x0000               
        e_or2i  r6, 0x003f               
        mtMAS3  r6

        msync           # Synchronize for running out of flash
        tlbwe
        se_isync        # Synchronize for running out of flash
        

        # Second MMU Entry First 256K SRAM - No Translation
        # MAS0 : ESEL=1
        # MAS1 : TSIZ=256Kbytes
        # MAS2 : EPN=0x400000000, W=0, I=1, M=0, G=0, E=big 
        # MAS3 : RPN=0x400000000, PERMIS=all 

        e_lis   r3, 0x1001
        mtMAS0  r3

        e_lis   r4, 0xC000
        e_or2i  r4, 0x0400     # changed to 512 for testing of lsm part
        mtMAS1  r4

        e_lis   r5, 0x4000
        e_or2i  r5, 0x0020
        mtMAS2  r5

        e_lis   r6, 0x4000
        e_or2i  r6, 0x003f
        mtMAS3  r6

        tlbwe

        # Third MMU Entry Second 256K SRAM 
        # MAS0 : ESEL=2
        # MAS1 : TSIZ=256Kbytes
        # MAS2 : EPN=0x50000000, W=0, I=1, M=0, G=0, E=big 
        # MAS3 : RPN=0x50000000, PERMIS=all 

        e_lis   r3, 0x1002
        mtMAS0  r3

        e_lis   r4, 0xC000
        e_or2i  r4, 0x0400
        mtMAS1  r4

        e_lis   r5, 0x5000
        e_or2i  r5, 0x0020
        mtMAS2  r5

        e_lis   r6, 0x5000
        e_or2i  r6, 0x003f
        mtMAS3  r6

        tlbwe

        # Peripheral Space in DPM mode things start at 0x8ff0_0000
        # will start at 0x8000_0000 and extend 512K 
        # MAS0 : ESEL=3
        # MAS1 : TSIZ=512Kbytes
        # MAS2 : EPN=0x8ff000000, W=0, I=0, M=0, G=0, E=big 
        # MAS3 : RPN=0x8ff000000, PERMIS=all 

        e_lis   r3, 0x1003
        mtMAS0  r3

        e_lis   r4, 0xC000
        e_or2i  r4, 0x0480
        mtMAS1  r4

        e_lis   r5, 0x8ff0
        e_or2i  r5, 0x0000
        mtMAS2  r5

        e_lis   r6, 0x8ff0
        e_or2i  r6, 0x003f
        mtMAS3  r6

        tlbwe    


        # Peripheral Space in DPM mode things start at 0x8ff0_0000
        # will start at 0xc3e0_0000 and extend 2M 
        # MAS0 : ESEL=4
        # MAS1 : TSIZ=2Mbytes
        # MAS2 : EPN=0xC30000000, W=0, I=0, M=0, G=0, E=big 
        # MAS3 : RPN=0xC30000000, PERMIS=all 

        e_lis   r3, 0x1004
        mtMAS0  r3

        e_lis   r4, 0xC000
        e_or2i  r4, 0x0580
        mtMAS1  r4

        e_lis   r5, 0xC3e0
        e_or2i  r5, 0x0000
        mtMAS2  r5

        e_lis   r6, 0xC3e0
        e_or2i  r6, 0x003f
        mtMAS3  r6

        tlbwe    

        # Peripheral Space in DPM mode things start at 0x8ff0_0000
        # will start at 0xFFE0_0000 and extend 1M 
        # MAS0 : ESEL=5
        # MAS1 : TSIZ=1Mbytes
        # MAS2 : EPN=0xFFE000000, W=0, I=0, M=0, G=0, E=big 
        # MAS3 : RPN=0xFFE000000, PERMIS=all 

        e_lis   r3, 0x1005
        mtMAS0  r3

        e_lis   r4, 0xC000
        e_or2i  r4, 0x0500
        mtMAS1  r4

        e_lis   r5, 0xFFE0
        e_or2i  r5, 0x0000
        mtMAS2  r5

        e_lis   r6, 0xFFE0
        e_or2i  r6, 0x003f
        mtMAS3  r6

        tlbwe    

         # Peripheral Space in DPM mode things start at 0x8ff0_0000
        # will start at 0xFFE0_0000 and extend 1M 
        # MAS0 : ESEL=6
        # MAS1 : TSIZ=512Kbytes
        # MAS2 : EPN=0xFFF000000, W=0, I=0, M=0, G=0, E=big 
        # MAS3 : RPN=0xFFF000000, PERMIS=all 

        e_lis   r3, 0x1006
        mtMAS0  r3

        e_lis   r4, 0xC000
        e_or2i  r4, 0x0480
        mtMAS1  r4

        e_lis   r5, 0xFFF0
        e_or2i  r5, 0x0000
        mtMAS2  r5

        e_lis   r6, 0xFFF0
        e_or2i  r6, 0x003f
        mtMAS3  r6

        tlbwe    
        
        # Peripheral Space in DPM mode things start at 0x8ff0_0000
        # will start at 0xFFF8_0000 and extend 1M 
        # MAS0 : ESEL=7
        # MAS1 : TSIZ=256Kbytes
        # MAS2 : EPN=0xFFF800000, W=0, I=0, M=0, G=0, E=big 
        # MAS3 : RPN=0xFFF800000, PERMIS=all 

        e_lis   r3, 0x1007
        mtMAS0  r3

        e_lis   r4, 0xC000
        e_or2i  r4, 0x0400
        mtMAS1  r4

        e_lis   r5, 0xFFF8
        e_or2i  r5, 0x0000
        mtMAS2  r5

        e_lis   r6, 0xFFF8
        e_or2i  r6, 0x003f
        mtMAS3  r6

        tlbwe    
        
        # Peripheral Space in DPM mode things start at 0x8ff0_0000
        # will start at 0xFFC0_0000 and extend 128K 
        # MAS0 : ESEL=8
        # MAS1 : TSIZ=128Kbytes
        # MAS2 : EPN=0xFFFC00000, W=0, I=0, M=0, G=0, E=big 
        # MAS3 : RPN=0xFFFC00000, PERMIS=all 

        e_lis   r3, 0x1008
        mtMAS0  r3

        e_lis   r4, 0xC000
        e_or2i  r4, 0x0380
        mtMAS1  r4

        e_lis   r5, 0xFFFC
        e_or2i  r5, 0x0000
        mtMAS2  r5

        e_lis   r6, 0xFFFC
        e_or2i  r6, 0x003f
        mtMAS3  r6

        tlbwe    

        # Peripheral Space in DPM mode things start at 0x8ff0_0000
        # will start at 0xFFFE_0000 and extend 64K 
        # MAS0 : ESEL=9
        # MAS1 : TSIZ=64Kbytes
        # MAS2 : EPN=0xFFFC00000, W=0, I=0, M=0, G=0, E=big 
        # MAS3 : RPN=0xFFFC00000, PERMIS=all 

        e_lis   r3, 0x1009
        mtMAS0  r3

        e_lis   r4, 0xC000
        e_or2i  r4, 0x0300
        mtMAS1  r4

        e_lis   r5, 0xFFFE
        e_or2i  r5, 0x0000
        mtMAS2  r5

        e_lis   r6, 0xFFFE
        e_or2i  r6, 0x003f
        mtMAS3  r6

        tlbwe
       
        
##------- Disable Watchdog  -----------------------------------------------
# for lsm only need this once.

#	e_lis     r6,0xfff3
#	e_or2i    r6,0x8010
#	e_li      r7,0xC520
#	se_stw    r7,0x0(r6)
#	e_li      r7,0xD928
#	se_stw    r7,0x0(r6) # Disengage soft-lock

#	e_lis     r6,0xfff3
#	e_or2i    r6,0x8000
#	e_lis     r7,0xff00
#	e_or2i    r7,0x10A
#	se_stw    r7,0x0(r6) # WEN = 0
	
##------- End of Disable Watchdog  -----------------------------------------

        ##-------- Branch to Core unique initialization codes ------------------

        e_lis   r5, 0x00
        mfspr   r6, 286                 # Core 0 ID = 0, Core 1 ID = 1
        
        cmplw   r6,r5
        e_bne   __CORE1      # if this is running on CORE 1, then jump to core 1
										         # otherwise fall through to ram init Core 0


        ##------- Initialise SRAM0 ECC ------------------------------------------
        
        e_lis   r5, _SRAM_BASE0_ADDR@h  # SRAM start address = 0x4000_0000
        e_or2i  r5, _SRAM_BASE0_ADDR@l
        
        e_lis   r6, _SRAM_SIZE@h        # SRAM size = 256K
        e_or2i  r6, _SRAM_SIZE@l         
#    
        e_srwi  r6, r6, 0x7             # Divide SRAM size by 128 bytes
        mtctr   r6                      # Move to counter for use with "bdnz"
            
sram_loop1:  

        e_stmw  r0,0x0(r5)              # Write all 32 registers to SRAM    
        e_addi  r5,r5,128               # Increment the RAM pointer to next 128byte
        e_bdnz  sram_loop1              # Loop for all of SRAM

		
        ##--------- Start Core 0 ----------------------------------------------- 
        ##-------------- Set up stack and run time environment Core 0 ----------
         e_lis   r11, __SP_INIT0@h        # Initialize stack pointer r1 to
         e_or2i  r11, __SP_INIT0@l        # value in linker command file.
         mr   r1,r11 

         e_lis   r13, _SDA_BASE_@h       # Initialize r13 to sdata base
         e_or2i  r13, _SDA_BASE_@l       # (provided by linker).    

         e_lis   r2, _SDA2_BASE_@h       # Initialize r2 to sdata2 base
         e_or2i  r2, _SDA2_BASE_@l       # (provided by linker).
    
         e_stwu  r0,-64(r1)              # Terminate stack.

	##--------- Initialised Data - ".data" --------------------------------------
DATACOPY0:
    	e_lis       r9, __DATA_SIZE@ha      # Load upper SRAM load size (# of bytes) into R9
    	e_or2i      r9, __DATA_SIZE@l       # Load lower SRAM load size into R9                                     
    	e_cmp16i    r9,0                    # Compare to see if equal to 0                                  
    	e_beq       ROMCPYEND0               # Exit cfg_ROMCPY if size is zero (no data to initialise)
                                        
    	mtctr       r9                      # Store no. of bytes to be moved in counter
                                        
    	e_lis       r10, __DATA_ROM_ADDR@h  # Load address of first SRAM load into R10
    	e_or2i      r10, __DATA_ROM_ADDR@l  # Load lower address of SRAM load into R10
    	e_subi      r10,r10, 1              # Decrement address to prepare for ROMCPYLOOP

    	e_lis       r5, __DATA_SRAM_ADDR@h  # Load upper SRAM address into R5 (from linker file)
    	e_or2i      r5, __DATA_SRAM_ADDR@l  # Load lower SRAM address into R5 (from linker file)
    	e_subi      r5, r5, 1               # Decrement address to prepare for ROMCPYLOOP

DATACPYLOOP0:
    	e_lbzu      r4, 1(r10)              # Load data byte at R10 into R4,incrementing (update) ROM address
    	e_stbu      r4, 1(r5)               # Store R4 data byte into SRAM at R5 and update SRAM address 
    	e_bdnz      DATACPYLOOP0             # Branch if more bytes to load from ROM

ROMCPYEND0:

##--------- Initialised Data - ".sdata" --------------------------------------
DATACOPY2:
    	e_lis       r9, __SDATA_SIZE@ha      # Load upper SRAM load size (# of bytes) into R9
    	e_or2i      r9, __SDATA_SIZE@l       # Load lower SRAM load size into R9                                     
    	e_cmp16i    r9,0                    # Compare to see if equal to 0                                  
    	e_beq       ROMCPYEND2               # Exit cfg_ROMCPY if size is zero (no data to initialise)
                                        
    	mtctr       r9                      # Store no. of bytes to be moved in counter
                                        
    	e_lis       r10, __SDATA_ROM_ADDR@h  # Load address of first SRAM load into R10
    	e_or2i      r10, __SDATA_ROM_ADDR@l  # Load lower address of SRAM load into R10
    	e_subi      r10,r10, 1              # Decrement address to prepare for ROMCPYLOOP

    	e_lis       r5, __SDATA_SRAM_ADDR@h  # Load upper SRAM address into R5 (from linker file)
    	e_or2i      r5, __SDATA_SRAM_ADDR@l  # Load lower SRAM address into R5 (from linker file)
    	e_subi      r5, r5, 1               # Decrement address to prepare for ROMCPYLOOP

DATACPYLOOP2:
    	e_lbzu      r4, 1(r10)              # Load data byte at R10 into R4,incrementing (update) ROM address
    	e_stbu      r4, 1(r5)               # Store R4 data byte into SRAM at R5 and update SRAM address 
    	e_bdnz      DATACPYLOOP2             # Branch if more bytes to load from ROM

ROMCPYEND2:
    
        e_b         main0

        ##--------- Start Core 1 ----------------------------------------------- 
        
__CORE1: ## After MMU setup - identical for both cores, then core 1 jumps here
        ##------- Initialise SRAM1 ECC ------------------------------------------
        
        e_lis   r5, _SRAM_BASE1_ADDR@h  # SRAM start address = 0x5000_0000
        e_or2i  r5, _SRAM_BASE1_ADDR@l
#        
        e_lis   r6, _SRAM_SIZE@h        # SRAM size = 256K
        e_or2i  r6, _SRAM_SIZE@l         
#    
        e_srwi  r6, r6, 0x7             # Divide SRAM size by 128 bytes
        mtctr   r6                      # Move to counter for use with "bdnz"
            
sram_loop2:  

        e_stmw  r0,0x0(r5)              # Write all 32 registers to SRAM    
        e_addi  r5,r5,128               # Increment the RAM pointer to next 128byte
        e_bdnz  sram_loop2              # Loop for all of SRAM

        ##--------------- Set up stack and run time environment Core 1 ---------
        e_lis   r11, __SP_INIT1@h        # Initialize stack pointer r1 thru r11 to
        e_or2i  r11, __SP_INIT1@l        # value in linker command file. 
    		mr r1,r11
		
        e_lis   r13, _SDA_BASE_@h       # Initialize r13 to sdata base
        e_or2i  r13, _SDA_BASE_@l       # (provided by linker).    

        e_lis   r2, _SDA2_BASE_@h       # Initialize r2 to sdata2 base
        e_or2i  r2, _SDA2_BASE_@l       # (provided by linker).
   
        e_stwu  r0,-64(r1)              # Terminate stack.
	
    	##--------- Initialised Data - ".data" --------------------------------------
DATACOPY1:
    	e_lis       r9, __DATA_SIZE@ha      # Load upper SRAM load size (# of bytes) into R9
    	e_or2i      r9, __DATA_SIZE@l       # Load lower SRAM load size into R9                                     
    	e_cmp16i    r9,0                    # Compare to see if equal to 0                                  
    	e_beq       ROMCPYEND1               # Exit cfg_ROMCPY if size is zero (no data to initialise)
                                        
    	mtctr       r9                      # Store no. of bytes to be moved in counter
                                        
    	e_lis       r10, __DATA_ROM_ADDR@h  # Load address of first SRAM load into R10
    	e_or2i      r10, __DATA_ROM_ADDR@l  # Load lower address of SRAM load into R10
    	e_subi      r10,r10, 1              # Decrement address to prepare for ROMCPYLOOP

    	e_lis       r5, __DATA_SRAM_ADDR@h  # Load upper SRAM address into R5 (from linker file)
    	e_or2i      r5, __DATA_SRAM_ADDR@l  # Load lower SRAM address into R5 (from linker file)
    	e_subi      r5, r5, 1               # Decrement address to prepare for ROMCPYLOOP

DATACPYLOOP1:
    	e_lbzu      r4, 1(r10)              # Load data byte at R10 into R4,incrementing (update) ROM address
    	e_stbu      r4, 1(r5)               # Store R4 data byte into SRAM at R5 and update SRAM address 
    	e_bdnz      DATACPYLOOP1             # Branch if more bytes to load from ROM

ROMCPYEND1:

    	
	
        e_b     main1
        
        ##---------------------------------------------------------------------- 
